<x-app-layout>
    <x-slot name="header">
        {{$booking->package->name}}
    </x-slot>

    <!-- Row -->
    <div class="row mt-4">
        <div class="col-md-10">
            <div class="card shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-4">
                        <h4 class="text-primary mb-0">Booking Summary</h4>
                        <span @class([ "badge px-3 py-2" , "bg-warning"=> $booking->status == 'pending',
                            "bg-success" => $booking->status == 'approved',
                            "bg-danger" => $booking->status == 'rejected',
                            "bg-info" => $booking->status == 'completed',
                            ])>{{$booking->status}}</span>
                    </div>

                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="booking-info">
                                <h6 class="text-muted">Package Title</h6>
                                <p class="fs-5">{{$booking->package->name}}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="booking-info">
                                <h6 class="text-muted">Travel with</h6>
                                <p class="fs-5">{{$booking->agent?->name??'Admin'}}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="booking-info">
                                <h6 class="text-muted">Travel Date</h6>
                                <p class="fs-5">{{$booking->package->start_date->format('d/m/Y')}}</p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="booking-info">
                                <h6 class="text-muted">Transaction ID</h6>
                                <p class="fs-5">{{$booking->trnx_id}}</p>
                            </div>
                        </div>
                    </div>

                    <hr class="my-4">

                    <div class="row g-4">
                        <div class="col-md-3">
                            <div class="booking-info">
                                <h6 class="text-muted">Adults</h6>
                                <p class="fs-5">{{$booking->adult}}</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="booking-info">
                                <h6 class="text-muted">Children</h6>
                                <p class="fs-5">{{$booking->child}}</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="booking-info">
                                <h6 class="text-muted">Infants</h6>
                                <p class="fs-5">{{$booking->infant}}</p>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="booking-info">
                                <h6 class="text-muted">Total Persons</h6>
                                <p class="fs-5">{{$booking->peoples}}</p>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4 p-4 bg-light rounded-3">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">Total Price</h5>
                            <h4 class="text-primary mb-0">৳{{number_format($booking->amount)}}</h4>
                        </div>
                    </div>

                    <div class="row g-4 mt-5">
                        <div class="co-lg-12mt-4 p-4 bg-dark rounded-3">
                            <h5 class="mb-0 text-white">Travelers</h5>
                        </div>
                        @forelse ($booking->travelers->groupBy('type') as $type => $travelers)
                        <div class="col-md-12 mt-4">
                            <h3 class="text-primary">{{ucfirst($type)}}</h3>
                            <div class="table-responsive">
                                <table class="table table-bordered text-nowrap border-bottom">
                                    <thead>
                                        <tr>
                                            <th class="border-bottom-0">Name</th>
                                            {{-- <th class="border-bottom-0">Email</th> --}}
                                            <th class="border-bottom-0">Phone</th>
                                            <th class="border-bottom-0">Date of birth</th>
                                            {{-- <th class="border-bottom-0">NID</th> --}}
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($travelers as $traveler)
                                        <tr>
                                            <td>{{$traveler->name}}</td>
                                            {{-- <td>{{$traveler->email}}</td> --}}
                                            <td>{{$traveler->phone}}</td>
                                            <td>{{$traveler->date_of_birth->format('D m, Y')}} ({{$traveler->date_of_birth->age}})</td>
                                            {{-- <td>{{$traveler->nid}}</td> --}}
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        @empty

                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

</x-app-layout>
